#include <dci.h>
#include <p30fxxxx.h>

/* DCI is enabled only for following devices */
#if defined(__dsPIC30F4013__) || defined(__dsPIC30F5011__) ||defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6014__)

/*********************************************************************
*    Function Name : WriteDCI									
*    Description   : This routine writes the data_out value  to one
                     of the transmit buffer locations given by buffer
*    Parameters    : unsigned char : buffer
*					 unsigned int  : data_out
*	 Return Value  : None
*********************************************************************/

void WriteDCI(unsigned int data_out,unsigned char buffer)
{
     (*(&TXBUF0+ (buffer&3))) = data_out;
}

#endif
